using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
namespace takmicenje
{
    internal class Program
    {
        struct vek
        {
            public int x, y, idx;
            public double angle;
        }

        static void Main(string[] args)
        {
            int n = int.Parse(Console.ReadLine());
            (int x, int y)[] potezi = new (int, int)[n];
            for (int i = 0; i < n; i++)
            {
                string a = Console.ReadLine();
                string[] la = a.Split();
                potezi[i] = (int.Parse(la[0]), int.Parse(la[1]));
            }
            vek[] v = new vek[n];

            for (int i = 0; i < n; i++)
            {
                v[i] = new vek
                {
                    x = potezi[i].x,
                    y = potezi[i].y,
                    idx = i,
                    angle = Math.Atan2(potezi[i].y, potezi[i].x)
                };
            }

            Array.Sort(v, (a, b) => a.angle.CompareTo(b.angle));

            vek[] vv = new vek[2 * n];
            for (int i = 0; i < n; i++)
            {
                vv[i] = v[i];
                vv[i + n] = v[i];
                vv[i + n].angle += 2 * Math.PI;
            }

            int l = 0;
            long sx = 0, sy = 0;
            double b = 0;
            int bL = 0, bR = -1;

            for (int r = 0; r < 2 * n; r++)
            {
                sx += vv[r].x;
                sy += vv[r].y;

                while (vv[r].angle - vv[l].angle >= Math.PI)
                {
                    sx -= vv[l].x;
                    sy -= vv[l].y;
                    l++;
                }

                double dist = Math.Sqrt((double)sx * sx + (double)sy * sy);
                if (dist > b)
                {
                    b = dist;
                    bL = l;
                    bR = r;
                }
            }
            List<int> res = new List<int>();
            for (int i = bL; i <= bR; i++)
                res.Add(vv[i].idx + 1);

            Console.WriteLine(res.Count);
            Console.WriteLine(string.Join(" ", res));
        }
    }
}